---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 5, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 092900 Added pkg_ALKINDI_CLUSTER.sp_SEL_Clusterable_Users to select user_ids for clusterable users
-- MSW 092900 Changed pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User_PC SQL statement to select -1 when a user hasn't evaluated a product
-- AHW 092900 Added pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_USER
-- AHW 092900 Added pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_PROD
-- MSW 092900 Added pkg_ALKINDI_CLUSTER.sp_SEL_Product_Cluster_Size to count the number of products in a product cluster
-- MSW 092900 Corrected pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_USER, changed o_evaluation_cursor_type to o_recommendation_cursor_type
-- MSW 092900 Corrected pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_PROD, changed o_evaluation_cursor_type to o_recommendation_cursor_type
-- MSW 092900 Added pkg_ALKINDI_CLUSTER.sp_SEL_UCID_From_UCIndex to select the User_Cluster_ID given the product_cluster_id and the user_cluster_index
-- MSW 100200 Changed output column name in pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User_PC from Eval to EVALUATION_SCALE_ID
-- MSW 100200 Corrected pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User_PC SQL statement added (+) to EVALUATION.USER_ID
-- MSW 100200 Added pkg_ALKINDI_CLUSTER.sp_DEL_PC_Stats_Relations to reset Product Cluster tables
-- MSW 100300 Added pkg_ALKINDI_CLUSTER.sp_CNT_UC_By_PC to count the number of user_clusters in given product_cluster
-- MSW 100300 Renamed REL_PRODUCT_CLUSTER_USER to USER_PRODUCT_CLUSTER_STAT (Table name changed)
-- MSW 100300 Renamed PRODUCT_CLUSTER_ACTIVE to PRODUCT_CLUSTER_ACTIVE_IND
-- MSW 100300 Added pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_PC
-- MSW 100400 Renamed USER_CLUSTER_PRODUCT_STAT to PRODUCT_USER_CLUSTER_STAT
-- MSW 100400 Renamed pkg_ALKINDI_CLUSTER.sp_SEL_UC_Prod_Stat_By_PC to sp_SEL_Prod_UC_Stat_By_PC
-- MSW 100400 Corrected pkg_ALKINDI_CLUSTER.sp_SEL_Prod_UC_Stat_By_PC, there was an error with the result set
-- MSW 100400 Changed datatype of pkg_ALKINDI_CLUSTER.sp_CNT_UC_By_PC from USER_CLUSTER.USER_CLUSTER_ID%TYPE to NUMBER
-- MSW 100400 Added pkg_ALKINDI_CLUSTER.sp_CNT_USER_By_UC
-- MSW 100400 Added pkg_ALKINDI_CLUSTER.sp_SEL_UCUserProdEval_By_PC
-- MSW 100400 Added pkg_ALKINDI_CLUSTER.sp_INS_USER_Into_UC
-- MSW 100400 Renamed pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_PC to sp_SEL_UserProdEval_By_PC
-- MSW 100500 Added pkg_ALKINDI_CLUSTER.sp_CNT_USER_By_UC_INDEX
-- MSW 100500 Added pkg_ALKINDI_CLUSTER.sp_DEL_USER_PC_Stat_By_PC
-- MSW 100500 Added pkg_ALKINDI_CLUSTER.sp_DEL_User_From_UC_By_PC
-- MSW 100500 Changed pkg_ALKINDI_CLUSTER.sp_INS_USER_Into_UC to prevent users in multiple user clusters in one product cluster
-- MSW 100500 Renamed pkg_ALKINDI_CLUSTER.sp_DEL_USER_PC_Stat_By_PC to sp_DEL_PROD_UC_Stat_By_PC
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_CLUSTER
AS
  TYPE CLUSTER_cursor_type is REF CURSOR;

  PROCEDURE sp_SEL_ProdEval_By_User(
	i_USER_ID			IN		EVALUATION.USER_ID%TYPE,	
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_ProdEval_By_User_PC(
	i_USER_ID 			IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_UserProdEval_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_UCUserProdEval_By_PC(							-- MSW 100400
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_UserProdEval_BY_UC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Prod_Stat_BY_UC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Prod_UC_Stat_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Clusterable_Users(
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);
	
  PROCEDURE sp_SEL_Product_Cluster_Size(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_Count_Of_Products	OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_UCID_From_UCIndex(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_USER_CLUSTER_ID		OUT		USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_PC_Stats_Relations(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_CNT_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_UC		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_CNT_User_By_UC(
	i_USER_CLUSTER_ID		IN		REL_USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_USER_Into_UC(
	i_USER_ID			IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_CNT_User_By_UC_INDEX(
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_PROD_UC_Stat_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE);

  PROCEDURE sp_DEL_User_From_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE);

END pkg_ALKINDI_CLUSTER;
/

SHOW ERRORS


-- ==========================================================================================


CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_CLUSTER
AS

-- For a supplied user id, select all of the products and evaluations for that user

 PROCEDURE sp_SEL_ProdEval_By_User(
	i_USER_ID 			IN		EVALUATION.USER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR
	SELECT PRODUCT_ID, EVALUATION_SCALE_ID FROM EVALUATION WHERE USER_ID = i_USER_ID;
	
   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6561;
		CLOSE o_CLUSTER_cursor_type;
 END sp_SEL_ProdEval_By_User;

-- ==========================================================================================

  PROCEDURE sp_SEL_ProdEval_By_User_PC(						-- MSW 092900 Changed SQL statement

-- For a supplied user and product cluster, select the products and evaluations of that
-- user for products that exist in the supplied product cluster

	i_USER_ID 			IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT REL_PRODUCT_CLUSTER.PRODUCT_ID
	     , DECODE(EVALUATION.EVALUATION_SCALE_ID, NULL, -1, EVALUATION.EVALUATION_SCALE_ID) AS EVALUATION_SCALE_ID
	  FROM REL_PRODUCT_CLUSTER, EVALUATION
	 WHERE REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
         AND EVALUATION.USER_ID(+) = i_USER_ID
	   AND EVALUATION.PRODUCT_ID(+) = REL_PRODUCT_CLUSTER.PRODUCT_ID
    ORDER BY REL_PRODUCT_CLUSTER.PRODUCT_INDEX;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6560;
		CLOSE o_CLUSTER_cursor_type;
 END sp_SEL_ProdEval_By_User_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_UserProdEval_By_PC(							-- MSW 100300

-- For a supplied product cluster, select the user, products and evaluations
-- for products that exist in the supplied product cluster

	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT all_user_prod_comb.USER_ID
	     , all_user_prod_comb.PRODUCT_ID
	     , DECODE(EVALUATION.EVALUATION_SCALE_ID,NULL,-1,EVALUATION.EVALUATION_SCALE_ID) AS EVALUATION_SCALE_ID
	  FROM all_user_prod_comb
	     , EVALUATION
	     , REL_PRODUCT_CLUSTER
	 WHERE all_user_prod_comb.USER_ID = EVALUATION.USER_ID(+)
	   AND all_user_prod_comb.PRODUCT_ID = EVALUATION.PRODUCT_ID(+)
	   AND REL_PRODUCT_CLUSTER.PRODUCT_ID = all_user_prod_comb.PRODUCT_ID
	   AND REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
    ORDER BY all_user_prod_comb.USER_ID
	     , REL_PRODUCT_CLUSTER.PRODUCT_INDEX;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
		CLOSE o_CLUSTER_cursor_type;
 END sp_SEL_UserProdEval_By_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_UCUserProdEval_By_PC(							-- MSW 100400
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT USER_CLUSTER.USER_CLUSTER_INDEX
	     , all_user_prod_comb.USER_id
	     , all_user_prod_comb.PRODUCT_ID
	     , DECODE(EVALUATION.EVALUATION_SCALE_ID,NULL,-1,EVALUATION.EVALUATION_SCALE_ID) AS EVALUATION_SCALE_ID
	  FROM all_user_prod_comb
	     , EVALUATION
	     , REL_USER_CLUSTER
	     , REL_PRODUCT_CLUSTER
	     , USER_CLUSTER
	 WHERE all_user_prod_comb.USER_ID = EVALUATION.USER_ID(+)
	   AND all_user_prod_comb.PRODUCT_ID = EVALUATION.PRODUCT_ID(+)
	   AND all_user_prod_comb.USER_ID = REL_USER_CLUSTER.USER_ID
	   AND USER_CLUSTER.USER_CLUSTER_ID = REL_USER_CLUSTER.USER_CLUSTER_ID
	   AND USER_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND REL_PRODUCT_CLUSTER.PRODUCT_ID = all_user_prod_comb.PRODUCT_ID
	   AND REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
    ORDER BY USER_CLUSTER.USER_CLUSTER_INDEX
	     , all_user_prod_comb.USER_ID
	     , REL_PRODUCT_CLUSTER.PRODUCT_INDEX;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
		CLOSE o_CLUSTER_cursor_type;
 END sp_SEL_UCUserProdEval_By_PC;

-- ==========================================================================================


-- For a supplied product cluster and user cluster index, select the products and evaluations of every
-- user associated with that user cluster but only the products that are associated with the supplied product
-- cluster


  PROCEDURE sp_SEL_UserProdEval_BY_UC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT /*+ PUSH_SUBQ */
		 EVALUATION.USER_ID
	     , EVALUATION.PRODUCT_ID
	     , EVALUATION.EVALUATION_SCALE_ID
	  FROM REL_PRODUCT_CLUSTER, EVALUATION, REL_USER_CLUSTER, USER_CLUSTER
	 WHERE REL_PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND REL_USER_CLUSTER.USER_CLUSTER_ID = 
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX);
	
   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6562;
		CLOSE o_CLUSTER_cursor_type;

  END sp_SEL_UserProdEval_BY_UC;

-- ==========================================================================================

-- For a supplied product cluster and user cluster index, select the mean, variance and fractions for each
-- product


  PROCEDURE sp_SEL_Prod_Stat_BY_UC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT /*+ PUSH_SUBQ */ 
	       PRODUCT_ID
	     , PROD_EVAL_MEAN_BY_UC
	     , PROD_EVAL_VARIANCE_BY_UC
	     , FRACTION_OF_UC_SEEN
	     , FRACTION_OF_UC_EVAL
	  FROM PRODUCT_USER_CLUSTER_STAT
	 WHERE PRODUCT_USER_CLUSTER_STAT.USER_CLUSTER_ID = 
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX);
	
   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6563;
		CLOSE o_CLUSTER_cursor_type;

  END sp_SEL_Prod_Stat_BY_UC;

-- ==========================================================================================

-- For a supplied product cluster, select the mean, variance and fractions for each product and user_cluster
-- in that product cluster (genre)

  PROCEDURE sp_SEL_Prod_UC_Stat_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR


	SELECT /*+ PUSH_SUBQ */ 
		 USER_CLUSTER.USER_CLUSTER_INDEX ,
		PRODUCT_USER_CLUSTER_STAT.USER_CLUSTER_ID
	     , PRODUCT_USER_CLUSTER_STAT.PRODUCT_ID
	     , PRODUCT_USER_CLUSTER_STAT.PROD_EVAL_MEAN_BY_UC
	     , PRODUCT_USER_CLUSTER_STAT.PROD_EVAL_VARIANCE_BY_UC
	     , PRODUCT_USER_CLUSTER_STAT.FRACTION_OF_UC_SEEN
	     , PRODUCT_USER_CLUSTER_STAT.FRACTION_OF_UC_EVAL
	  FROM PRODUCT_USER_CLUSTER_STAT
	     , USER_CLUSTER	
	 WHERE PRODUCT_USER_CLUSTER_STAT.USER_CLUSTER_ID IN 
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID)
	   AND PRODUCT_USER_CLUSTER_STAT.USER_CLUSTER_ID = USER_CLUSTER.USER_CLUSTER_ID;
	
   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6564;
		CLOSE o_CLUSTER_cursor_type;

   END sp_SEL_Prod_UC_Stat_By_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_Clusterable_Users(						-- MSW 092900 For OK,BK
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT USER_ID
	  FROM USER_ID;
	
   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6566;
		CLOSE o_CLUSTER_cursor_type;

   END sp_SEL_Clusterable_Users;

-- ==========================================================================================

  PROCEDURE sp_SEL_Product_Cluster_Size(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_Count_Of_Products	OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(PRODUCT_ID) INTO o_Count_Of_Products
	  FROM REL_PRODUCT_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6570;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6571;

   END sp_SEL_Product_Cluster_Size;

-- ==========================================================================================

  PROCEDURE sp_SEL_UCID_From_UCIndex(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_USER_CLUSTER_ID		OUT		USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT USER_CLUSTER_ID INTO o_USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6572;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6573;

   END sp_SEL_UCID_From_UCIndex;

-- ==========================================================================================

  PROCEDURE sp_DEL_PC_Stats_Relations(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	DELETE 
	  FROM PRODUCT_USER_CLUSTER_STAT
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM INTERCLUSTER_DISTANCE
	 WHERE USER_CLUSTER_ID1 IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID)
	    OR USER_CLUSTER_ID2 IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM USER_CLUSTER_DISTANCE
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM USER_CLUSTER_MEAN_DISTANCE
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM USER_PRODUCT_CLUSTER_STAT
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

	DELETE 
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_DEL_PC_Stats_Relations;

-- ==========================================================================================

  PROCEDURE sp_CNT_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_UC		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_CLUSTER_ID) INTO o_COUNT_OF_UC
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_UC_By_PC;

-- ==========================================================================================

  PROCEDURE sp_CNT_User_By_UC(
	i_USER_CLUSTER_ID		IN		REL_USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_ID) INTO o_COUNT_OF_User
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID = i_USER_CLUSTER_ID;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_User_By_UC;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_Into_UC(
	i_USER_ID			IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS 
	v_USER_IN_PC_IND NUMBER;
   BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_CLUSTER_ID) INTO v_USER_IN_PC_IND
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID = i_USER_ID
	   AND USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

IF v_USER_IN_PC_IND = 0 THEN
	INSERT INTO REL_USER_CLUSTER (USER_CLUSTER_ID, USER_ID)
	SELECT USER_CLUSTER_ID, i_USER_ID
	  FROM USER_CLUSTER
	 WHERE USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;
ELSE	
	UPDATE REL_USER_CLUSTER
	   SET USER_CLUSTER_ID = 
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID)
	 WHERE USER_ID = i_USER_ID;
END IF;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_INS_USER_Into_UC;

-- ==========================================================================================

  PROCEDURE sp_CNT_User_By_UC_INDEX(
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_ID) INTO o_COUNT_OF_User
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_User_By_UC_INDEX;

-- ==========================================================================================

  PROCEDURE sp_DEL_PROD_UC_Stat_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE)
   IS BEGIN
	DELETE 
	  FROM PRODUCT_USER_CLUSTER_STAT
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

   END sp_DEL_PROD_UC_Stat_By_PC;

-- ==========================================================================================

  PROCEDURE sp_DEL_User_From_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE)

   IS BEGIN
	DELETE 
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

   END sp_DEL_User_From_UC_By_PC;



-- ==========================================================================================

END pkg_ALKINDI_CLUSTER;
/

SHOW ERRORS
